package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListXssMatchSetsResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    xssMatchSets: Optional[Iterable[zio.aws.waf.model.XssMatchSetSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListXssMatchSetsResponse = {
    import ListXssMatchSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListXssMatchSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        xssMatchSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.xssMatchSets)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ListXssMatchSetsResponse.ReadOnly =
    zio.aws.waf.model.ListXssMatchSetsResponse.wrap(buildAwsValue())
}
object ListXssMatchSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListXssMatchSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ListXssMatchSetsResponse =
      zio.aws.waf.model.ListXssMatchSetsResponse(
        nextMarker.map(value => value),
        xssMatchSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[NextMarker]
    def xssMatchSets
        : Optional[List[zio.aws.waf.model.XssMatchSetSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getXssMatchSets: ZIO[Any, AwsError, List[
      zio.aws.waf.model.XssMatchSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("xssMatchSets", xssMatchSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListXssMatchSetsResponse
  ) extends zio.aws.waf.model.ListXssMatchSetsResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
    override val xssMatchSets
        : Optional[List[zio.aws.waf.model.XssMatchSetSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.xssMatchSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.waf.model.XssMatchSetSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListXssMatchSetsResponse
  ): zio.aws.waf.model.ListXssMatchSetsResponse.ReadOnly = new Wrapper(impl)
}
