package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters._
final case class UpdateRegexPatternSetRequest(
    regexPatternSetId: ResourceId,
    updates: Iterable[zio.aws.waf.model.RegexPatternSetUpdate],
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateRegexPatternSetRequest = {
    import UpdateRegexPatternSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateRegexPatternSetRequest
      .builder()
      .regexPatternSetId(ResourceId.unwrap(regexPatternSetId): java.lang.String)
      .updates(updates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.UpdateRegexPatternSetRequest.ReadOnly =
    zio.aws.waf.model.UpdateRegexPatternSetRequest.wrap(buildAwsValue())
}
object UpdateRegexPatternSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateRegexPatternSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.UpdateRegexPatternSetRequest =
      zio.aws.waf.model.UpdateRegexPatternSetRequest(
        regexPatternSetId,
        updates.map { item =>
          item.asEditable
        },
        changeToken
      )
    def regexPatternSetId: ResourceId
    def updates: List[zio.aws.waf.model.RegexPatternSetUpdate.ReadOnly]
    def changeToken: ChangeToken
    def getRegexPatternSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(regexPatternSetId)
    def getUpdates: ZIO[Any, Nothing, List[
      zio.aws.waf.model.RegexPatternSetUpdate.ReadOnly
    ]] = ZIO.succeed(updates)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateRegexPatternSetRequest
  ) extends zio.aws.waf.model.UpdateRegexPatternSetRequest.ReadOnly {
    override val regexPatternSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.regexPatternSetId())
    override val updates
        : List[zio.aws.waf.model.RegexPatternSetUpdate.ReadOnly] = impl
      .updates()
      .asScala
      .map { item =>
        zio.aws.waf.model.RegexPatternSetUpdate.wrap(item)
      }
      .toList
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateRegexPatternSetRequest
  ): zio.aws.waf.model.UpdateRegexPatternSetRequest.ReadOnly = new Wrapper(impl)
}
