package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ByteMatchSetUpdate(
    action: zio.aws.waf.model.ChangeAction,
    byteMatchTuple: zio.aws.waf.model.ByteMatchTuple
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate = {
    import ByteMatchSetUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate
      .builder()
      .action(action.unwrap)
      .byteMatchTuple(byteMatchTuple.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ByteMatchSetUpdate.ReadOnly =
    zio.aws.waf.model.ByteMatchSetUpdate.wrap(buildAwsValue())
}
object ByteMatchSetUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ByteMatchSetUpdate =
      zio.aws.waf.model.ByteMatchSetUpdate(action, byteMatchTuple.asEditable)
    def action: zio.aws.waf.model.ChangeAction
    def byteMatchTuple: zio.aws.waf.model.ByteMatchTuple.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.waf.model.ChangeAction] =
      ZIO.succeed(action)
    def getByteMatchTuple
        : ZIO[Any, Nothing, zio.aws.waf.model.ByteMatchTuple.ReadOnly] =
      ZIO.succeed(byteMatchTuple)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate
  ) extends zio.aws.waf.model.ByteMatchSetUpdate.ReadOnly {
    override val action: zio.aws.waf.model.ChangeAction =
      zio.aws.waf.model.ChangeAction.wrap(impl.action())
    override val byteMatchTuple: zio.aws.waf.model.ByteMatchTuple.ReadOnly =
      zio.aws.waf.model.ByteMatchTuple.wrap(impl.byteMatchTuple())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate
  ): zio.aws.waf.model.ByteMatchSetUpdate.ReadOnly = new Wrapper(impl)
}
