package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.{
  ChangeToken,
  RateLimit,
  MetricName,
  ResourceName
}
import scala.jdk.CollectionConverters.*
final case class CreateRateBasedRuleRequest(
    name: ResourceName,
    metricName: MetricName,
    rateKey: zio.aws.waf.model.RateKey,
    rateLimit: RateLimit,
    changeToken: ChangeToken,
    tags: Optional[Iterable[zio.aws.waf.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateRateBasedRuleRequest = {
    import CreateRateBasedRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateRateBasedRuleRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .rateKey(rateKey.unwrap)
      .rateLimit(RateLimit.unwrap(rateLimit): java.lang.Long)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateRateBasedRuleRequest.ReadOnly =
    zio.aws.waf.model.CreateRateBasedRuleRequest.wrap(buildAwsValue())
}
object CreateRateBasedRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateRateBasedRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateRateBasedRuleRequest =
      zio.aws.waf.model.CreateRateBasedRuleRequest(
        name,
        metricName,
        rateKey,
        rateLimit,
        changeToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: ResourceName
    def metricName: MetricName
    def rateKey: zio.aws.waf.model.RateKey
    def rateLimit: RateLimit
    def changeToken: ChangeToken
    def tags: Optional[List[zio.aws.waf.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
    def getRateKey: ZIO[Any, Nothing, zio.aws.waf.model.RateKey] =
      ZIO.succeed(rateKey)
    def getRateLimit: ZIO[Any, Nothing, RateLimit] = ZIO.succeed(rateLimit)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.waf.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateRateBasedRuleRequest
  ) extends zio.aws.waf.model.CreateRateBasedRuleRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.waf.model.primitives.ResourceName(impl.name())
    override val metricName: MetricName =
      zio.aws.waf.model.primitives.MetricName(impl.metricName())
    override val rateKey: zio.aws.waf.model.RateKey =
      zio.aws.waf.model.RateKey.wrap(impl.rateKey())
    override val rateLimit: RateLimit =
      zio.aws.waf.model.primitives.RateLimit(impl.rateLimit())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
    override val tags: Optional[List[zio.aws.waf.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.waf.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateRateBasedRuleRequest
  ): zio.aws.waf.model.CreateRateBasedRuleRequest.ReadOnly = new Wrapper(impl)
}
