package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters.*
final case class CreateRuleGroupResponse(
    ruleGroup: Optional[zio.aws.waf.model.RuleGroup] = Optional.Absent,
    changeToken: Optional[ChangeToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateRuleGroupResponse = {
    import CreateRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateRuleGroupResponse
      .builder()
      .optionallyWith(ruleGroup.map(value => value.buildAwsValue()))(
        _.ruleGroup
      )
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateRuleGroupResponse.ReadOnly =
    zio.aws.waf.model.CreateRuleGroupResponse.wrap(buildAwsValue())
}
object CreateRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateRuleGroupResponse =
      zio.aws.waf.model.CreateRuleGroupResponse(
        ruleGroup.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def ruleGroup: Optional[zio.aws.waf.model.RuleGroup.ReadOnly]
    def changeToken: Optional[ChangeToken]
    def getRuleGroup: ZIO[Any, AwsError, zio.aws.waf.model.RuleGroup.ReadOnly] =
      AwsError.unwrapOptionField("ruleGroup", ruleGroup)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateRuleGroupResponse
  ) extends zio.aws.waf.model.CreateRuleGroupResponse.ReadOnly {
    override val ruleGroup: Optional[zio.aws.waf.model.RuleGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleGroup())
        .map(value => zio.aws.waf.model.RuleGroup.wrap(value))
    override val changeToken: Optional[ChangeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateRuleGroupResponse
  ): zio.aws.waf.model.CreateRuleGroupResponse.ReadOnly = new Wrapper(impl)
}
