package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters.*
final case class CreateXssMatchSetResponse(
    xssMatchSet: Optional[zio.aws.waf.model.XssMatchSet] = Optional.Absent,
    changeToken: Optional[ChangeToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateXssMatchSetResponse = {
    import CreateXssMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateXssMatchSetResponse
      .builder()
      .optionallyWith(xssMatchSet.map(value => value.buildAwsValue()))(
        _.xssMatchSet
      )
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateXssMatchSetResponse.ReadOnly =
    zio.aws.waf.model.CreateXssMatchSetResponse.wrap(buildAwsValue())
}
object CreateXssMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateXssMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateXssMatchSetResponse =
      zio.aws.waf.model.CreateXssMatchSetResponse(
        xssMatchSet.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def xssMatchSet: Optional[zio.aws.waf.model.XssMatchSet.ReadOnly]
    def changeToken: Optional[ChangeToken]
    def getXssMatchSet
        : ZIO[Any, AwsError, zio.aws.waf.model.XssMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("xssMatchSet", xssMatchSet)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateXssMatchSetResponse
  ) extends zio.aws.waf.model.CreateXssMatchSetResponse.ReadOnly {
    override val xssMatchSet: Optional[zio.aws.waf.model.XssMatchSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.xssMatchSet())
        .map(value => zio.aws.waf.model.XssMatchSet.wrap(value))
    override val changeToken: Optional[ChangeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateXssMatchSetResponse
  ): zio.aws.waf.model.CreateXssMatchSetResponse.ReadOnly = new Wrapper(impl)
}
