package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters.*
final case class DeleteIpSetResponse(
    changeToken: Optional[ChangeToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteIpSetResponse = {
    import DeleteIpSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteIpSetResponse
      .builder()
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.DeleteIpSetResponse.ReadOnly =
    zio.aws.waf.model.DeleteIpSetResponse.wrap(buildAwsValue())
}
object DeleteIpSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteIpSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.DeleteIpSetResponse =
      zio.aws.waf.model.DeleteIpSetResponse(changeToken.map(value => value))
    def changeToken: Optional[ChangeToken]
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteIpSetResponse
  ) extends zio.aws.waf.model.DeleteIpSetResponse.ReadOnly {
    override val changeToken: Optional[ChangeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteIpSetResponse
  ): zio.aws.waf.model.DeleteIpSetResponse.ReadOnly = new Wrapper(impl)
}
