package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ResourceArn
import scala.jdk.CollectionConverters.*
final case class DeleteLoggingConfigurationRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteLoggingConfigurationRequest = {
    import DeleteLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteLoggingConfigurationRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.DeleteLoggingConfigurationRequest.ReadOnly =
    zio.aws.waf.model.DeleteLoggingConfigurationRequest.wrap(buildAwsValue())
}
object DeleteLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.DeleteLoggingConfigurationRequest =
      zio.aws.waf.model.DeleteLoggingConfigurationRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteLoggingConfigurationRequest
  ) extends zio.aws.waf.model.DeleteLoggingConfigurationRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.waf.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteLoggingConfigurationRequest
  ): zio.aws.waf.model.DeleteLoggingConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
