package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters.*
final case class DeleteRuleGroupRequest(
    ruleGroupId: ResourceId,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteRuleGroupRequest = {
    import DeleteRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteRuleGroupRequest
      .builder()
      .ruleGroupId(ResourceId.unwrap(ruleGroupId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.DeleteRuleGroupRequest.ReadOnly =
    zio.aws.waf.model.DeleteRuleGroupRequest.wrap(buildAwsValue())
}
object DeleteRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.DeleteRuleGroupRequest =
      zio.aws.waf.model.DeleteRuleGroupRequest(ruleGroupId, changeToken)
    def ruleGroupId: ResourceId
    def changeToken: ChangeToken
    def getRuleGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleGroupId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteRuleGroupRequest
  ) extends zio.aws.waf.model.DeleteRuleGroupRequest.ReadOnly {
    override val ruleGroupId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ruleGroupId())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteRuleGroupRequest
  ): zio.aws.waf.model.DeleteRuleGroupRequest.ReadOnly = new Wrapper(impl)
}
