package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class GetIpSetRequest(ipSetId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetIpSetRequest = {
    import GetIpSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetIpSetRequest
      .builder()
      .ipSetId(ResourceId.unwrap(ipSetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetIpSetRequest.ReadOnly =
    zio.aws.waf.model.GetIpSetRequest.wrap(buildAwsValue())
}
object GetIpSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetIpSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetIpSetRequest =
      zio.aws.waf.model.GetIpSetRequest(ipSetId)
    def ipSetId: ResourceId
    def getIpSetId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ipSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetIpSetRequest
  ) extends zio.aws.waf.model.GetIpSetRequest.ReadOnly {
    override val ipSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ipSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetIpSetRequest
  ): zio.aws.waf.model.GetIpSetRequest.ReadOnly = new Wrapper(impl)
}
