package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRegexMatchSetResponse(
    regexMatchSet: Optional[zio.aws.waf.model.RegexMatchSet] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRegexMatchSetResponse = {
    import GetRegexMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRegexMatchSetResponse
      .builder()
      .optionallyWith(regexMatchSet.map(value => value.buildAwsValue()))(
        _.regexMatchSet
      )
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetRegexMatchSetResponse.ReadOnly =
    zio.aws.waf.model.GetRegexMatchSetResponse.wrap(buildAwsValue())
}
object GetRegexMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRegexMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetRegexMatchSetResponse =
      zio.aws.waf.model
        .GetRegexMatchSetResponse(regexMatchSet.map(value => value.asEditable))
    def regexMatchSet: Optional[zio.aws.waf.model.RegexMatchSet.ReadOnly]
    def getRegexMatchSet
        : ZIO[Any, AwsError, zio.aws.waf.model.RegexMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("regexMatchSet", regexMatchSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRegexMatchSetResponse
  ) extends zio.aws.waf.model.GetRegexMatchSetResponse.ReadOnly {
    override val regexMatchSet
        : Optional[zio.aws.waf.model.RegexMatchSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regexMatchSet())
        .map(value => zio.aws.waf.model.RegexMatchSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRegexMatchSetResponse
  ): zio.aws.waf.model.GetRegexMatchSetResponse.ReadOnly = new Wrapper(impl)
}
