package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class GetRuleGroupRequest(ruleGroupId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRuleGroupRequest = {
    import GetRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRuleGroupRequest
      .builder()
      .ruleGroupId(ResourceId.unwrap(ruleGroupId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetRuleGroupRequest.ReadOnly =
    zio.aws.waf.model.GetRuleGroupRequest.wrap(buildAwsValue())
}
object GetRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetRuleGroupRequest =
      zio.aws.waf.model.GetRuleGroupRequest(ruleGroupId)
    def ruleGroupId: ResourceId
    def getRuleGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRuleGroupRequest
  ) extends zio.aws.waf.model.GetRuleGroupRequest.ReadOnly {
    override val ruleGroupId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ruleGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRuleGroupRequest
  ): zio.aws.waf.model.GetRuleGroupRequest.ReadOnly = new Wrapper(impl)
}
