package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.NextMarker
import scala.jdk.CollectionConverters.*
final case class ListIpSetsResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    ipSets: Optional[Iterable[zio.aws.waf.model.IPSetSummary]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListIpSetsResponse = {
    import ListIpSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListIpSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        ipSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipSets)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ListIpSetsResponse.ReadOnly =
    zio.aws.waf.model.ListIpSetsResponse.wrap(buildAwsValue())
}
object ListIpSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListIpSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ListIpSetsResponse =
      zio.aws.waf.model.ListIpSetsResponse(
        nextMarker.map(value => value),
        ipSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[NextMarker]
    def ipSets: Optional[List[zio.aws.waf.model.IPSetSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getIpSets
        : ZIO[Any, AwsError, List[zio.aws.waf.model.IPSetSummary.ReadOnly]] =
      AwsError.unwrapOptionField("ipSets", ipSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListIpSetsResponse
  ) extends zio.aws.waf.model.ListIpSetsResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
    override val ipSets
        : Optional[List[zio.aws.waf.model.IPSetSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.waf.model.IPSetSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListIpSetsResponse
  ): zio.aws.waf.model.ListIpSetsResponse.ReadOnly = new Wrapper(impl)
}
