package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.NextMarker
import scala.jdk.CollectionConverters.*
final case class ListRateBasedRulesResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    rules: Optional[Iterable[zio.aws.waf.model.RuleSummary]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListRateBasedRulesResponse = {
    import ListRateBasedRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListRateBasedRulesResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ListRateBasedRulesResponse.ReadOnly =
    zio.aws.waf.model.ListRateBasedRulesResponse.wrap(buildAwsValue())
}
object ListRateBasedRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListRateBasedRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ListRateBasedRulesResponse =
      zio.aws.waf.model.ListRateBasedRulesResponse(
        nextMarker.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[NextMarker]
    def rules: Optional[List[zio.aws.waf.model.RuleSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getRules
        : ZIO[Any, AwsError, List[zio.aws.waf.model.RuleSummary.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListRateBasedRulesResponse
  ) extends zio.aws.waf.model.ListRateBasedRulesResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
    override val rules: Optional[List[zio.aws.waf.model.RuleSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.waf.model.RuleSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListRateBasedRulesResponse
  ): zio.aws.waf.model.ListRateBasedRulesResponse.ReadOnly = new Wrapper(impl)
}
