package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.NextMarker
import scala.jdk.CollectionConverters.*
final case class ListRegexPatternSetsResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    regexPatternSets: Optional[
      Iterable[zio.aws.waf.model.RegexPatternSetSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListRegexPatternSetsResponse = {
    import ListRegexPatternSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListRegexPatternSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        regexPatternSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regexPatternSets)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ListRegexPatternSetsResponse.ReadOnly =
    zio.aws.waf.model.ListRegexPatternSetsResponse.wrap(buildAwsValue())
}
object ListRegexPatternSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListRegexPatternSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ListRegexPatternSetsResponse =
      zio.aws.waf.model.ListRegexPatternSetsResponse(
        nextMarker.map(value => value),
        regexPatternSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[NextMarker]
    def regexPatternSets
        : Optional[List[zio.aws.waf.model.RegexPatternSetSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getRegexPatternSets: ZIO[Any, AwsError, List[
      zio.aws.waf.model.RegexPatternSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("regexPatternSets", regexPatternSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListRegexPatternSetsResponse
  ) extends zio.aws.waf.model.ListRegexPatternSetsResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
    override val regexPatternSets
        : Optional[List[zio.aws.waf.model.RegexPatternSetSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regexPatternSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.waf.model.RegexPatternSetSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListRegexPatternSetsResponse
  ): zio.aws.waf.model.ListRegexPatternSetsResponse.ReadOnly = new Wrapper(impl)
}
