package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ResourceName, ResourceId}
import scala.jdk.CollectionConverters.*
final case class RegexPatternSetSummary(
    regexPatternSetId: ResourceId,
    name: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.RegexPatternSetSummary = {
    import RegexPatternSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RegexPatternSetSummary
      .builder()
      .regexPatternSetId(ResourceId.unwrap(regexPatternSetId): java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.RegexPatternSetSummary.ReadOnly =
    zio.aws.waf.model.RegexPatternSetSummary.wrap(buildAwsValue())
}
object RegexPatternSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.RegexPatternSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.RegexPatternSetSummary =
      zio.aws.waf.model.RegexPatternSetSummary(regexPatternSetId, name)
    def regexPatternSetId: ResourceId
    def name: ResourceName
    def getRegexPatternSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(regexPatternSetId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RegexPatternSetSummary
  ) extends zio.aws.waf.model.RegexPatternSetSummary.ReadOnly {
    override val regexPatternSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.regexPatternSetId())
    override val name: ResourceName =
      zio.aws.waf.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RegexPatternSetSummary
  ): zio.aws.waf.model.RegexPatternSetSummary.ReadOnly = new Wrapper(impl)
}
