package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.{MetricName, ResourceName, ResourceId}
import scala.jdk.CollectionConverters.*
final case class Rule(
    ruleId: ResourceId,
    name: Optional[ResourceName] = Optional.Absent,
    metricName: Optional[MetricName] = Optional.Absent,
    predicates: Iterable[zio.aws.waf.model.Predicate]
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.Rule
      .builder()
      .ruleId(ResourceId.unwrap(ruleId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .predicates(predicates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.Rule.ReadOnly =
    zio.aws.waf.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.Rule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.Rule = zio.aws.waf.model.Rule(
      ruleId,
      name.map(value => value),
      metricName.map(value => value),
      predicates.map { item =>
        item.asEditable
      }
    )
    def ruleId: ResourceId
    def name: Optional[ResourceName]
    def metricName: Optional[MetricName]
    def predicates: List[zio.aws.waf.model.Predicate.ReadOnly]
    def getRuleId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getPredicates
        : ZIO[Any, Nothing, List[zio.aws.waf.model.Predicate.ReadOnly]] =
      ZIO.succeed(predicates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.Rule
  ) extends zio.aws.waf.model.Rule.ReadOnly {
    override val ruleId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ruleId())
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.waf.model.primitives.ResourceName(value))
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.waf.model.primitives.MetricName(value))
    override val predicates: List[zio.aws.waf.model.Predicate.ReadOnly] = impl
      .predicates()
      .asScala
      .map { item =>
        zio.aws.waf.model.Predicate.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.Rule
  ): zio.aws.waf.model.Rule.ReadOnly = new Wrapper(impl)
}
