package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SizeConstraintSetUpdate(
    action: zio.aws.waf.model.ChangeAction,
    sizeConstraint: zio.aws.waf.model.SizeConstraint
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.SizeConstraintSetUpdate = {
    import SizeConstraintSetUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.SizeConstraintSetUpdate
      .builder()
      .action(action.unwrap)
      .sizeConstraint(sizeConstraint.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.waf.model.SizeConstraintSetUpdate.ReadOnly =
    zio.aws.waf.model.SizeConstraintSetUpdate.wrap(buildAwsValue())
}
object SizeConstraintSetUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.SizeConstraintSetUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.SizeConstraintSetUpdate =
      zio.aws.waf.model
        .SizeConstraintSetUpdate(action, sizeConstraint.asEditable)
    def action: zio.aws.waf.model.ChangeAction
    def sizeConstraint: zio.aws.waf.model.SizeConstraint.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.waf.model.ChangeAction] =
      ZIO.succeed(action)
    def getSizeConstraint
        : ZIO[Any, Nothing, zio.aws.waf.model.SizeConstraint.ReadOnly] =
      ZIO.succeed(sizeConstraint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.SizeConstraintSetUpdate
  ) extends zio.aws.waf.model.SizeConstraintSetUpdate.ReadOnly {
    override val action: zio.aws.waf.model.ChangeAction =
      zio.aws.waf.model.ChangeAction.wrap(impl.action())
    override val sizeConstraint: zio.aws.waf.model.SizeConstraint.ReadOnly =
      zio.aws.waf.model.SizeConstraint.wrap(impl.sizeConstraint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.SizeConstraintSetUpdate
  ): zio.aws.waf.model.SizeConstraintSetUpdate.ReadOnly = new Wrapper(impl)
}
