package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.{ResourceName, ResourceId}
import scala.jdk.CollectionConverters.*
final case class SqlInjectionMatchSet(
    sqlInjectionMatchSetId: ResourceId,
    name: Optional[ResourceName] = Optional.Absent,
    sqlInjectionMatchTuples: Iterable[zio.aws.waf.model.SqlInjectionMatchTuple]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.SqlInjectionMatchSet = {
    import SqlInjectionMatchSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.SqlInjectionMatchSet
      .builder()
      .sqlInjectionMatchSetId(
        ResourceId.unwrap(sqlInjectionMatchSetId): java.lang.String
      )
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .sqlInjectionMatchTuples(sqlInjectionMatchTuples.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.SqlInjectionMatchSet.ReadOnly =
    zio.aws.waf.model.SqlInjectionMatchSet.wrap(buildAwsValue())
}
object SqlInjectionMatchSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.SqlInjectionMatchSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.SqlInjectionMatchSet =
      zio.aws.waf.model.SqlInjectionMatchSet(
        sqlInjectionMatchSetId,
        name.map(value => value),
        sqlInjectionMatchTuples.map { item =>
          item.asEditable
        }
      )
    def sqlInjectionMatchSetId: ResourceId
    def name: Optional[ResourceName]
    def sqlInjectionMatchTuples
        : List[zio.aws.waf.model.SqlInjectionMatchTuple.ReadOnly]
    def getSqlInjectionMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(sqlInjectionMatchSetId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getSqlInjectionMatchTuples: ZIO[Any, Nothing, List[
      zio.aws.waf.model.SqlInjectionMatchTuple.ReadOnly
    ]] = ZIO.succeed(sqlInjectionMatchTuples)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.SqlInjectionMatchSet
  ) extends zio.aws.waf.model.SqlInjectionMatchSet.ReadOnly {
    override val sqlInjectionMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.sqlInjectionMatchSetId())
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.waf.model.primitives.ResourceName(value))
    override val sqlInjectionMatchTuples
        : List[zio.aws.waf.model.SqlInjectionMatchTuple.ReadOnly] = impl
      .sqlInjectionMatchTuples()
      .asScala
      .map { item =>
        zio.aws.waf.model.SqlInjectionMatchTuple.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.SqlInjectionMatchSet
  ): zio.aws.waf.model.SqlInjectionMatchSet.ReadOnly = new Wrapper(impl)
}
