package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.ResourceArn
import scala.jdk.CollectionConverters.*
final case class TagInfoForResource(
    resourceARN: Optional[ResourceArn] = Optional.Absent,
    tagList: Optional[Iterable[zio.aws.waf.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.TagInfoForResource = {
    import TagInfoForResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.TagInfoForResource
      .builder()
      .optionallyWith(
        resourceARN.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.TagInfoForResource.ReadOnly =
    zio.aws.waf.model.TagInfoForResource.wrap(buildAwsValue())
}
object TagInfoForResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.TagInfoForResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.TagInfoForResource =
      zio.aws.waf.model.TagInfoForResource(
        resourceARN.map(value => value),
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceARN: Optional[ResourceArn]
    def tagList: Optional[List[zio.aws.waf.model.Tag.ReadOnly]]
    def getResourceARN: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getTagList: ZIO[Any, AwsError, List[zio.aws.waf.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.TagInfoForResource
  ) extends zio.aws.waf.model.TagInfoForResource.ReadOnly {
    override val resourceARN: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceARN())
      .map(value => zio.aws.waf.model.primitives.ResourceArn(value))
    override val tagList: Optional[List[zio.aws.waf.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.waf.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.TagInfoForResource
  ): zio.aws.waf.model.TagInfoForResource.ReadOnly = new Wrapper(impl)
}
