package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters.*
final case class UpdateIpSetRequest(
    ipSetId: ResourceId,
    changeToken: ChangeToken,
    updates: Iterable[zio.aws.waf.model.IPSetUpdate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateIpSetRequest = {
    import UpdateIpSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateIpSetRequest
      .builder()
      .ipSetId(ResourceId.unwrap(ipSetId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .updates(updates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.UpdateIpSetRequest.ReadOnly =
    zio.aws.waf.model.UpdateIpSetRequest.wrap(buildAwsValue())
}
object UpdateIpSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateIpSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.UpdateIpSetRequest =
      zio.aws.waf.model.UpdateIpSetRequest(
        ipSetId,
        changeToken,
        updates.map { item =>
          item.asEditable
        }
      )
    def ipSetId: ResourceId
    def changeToken: ChangeToken
    def updates: List[zio.aws.waf.model.IPSetUpdate.ReadOnly]
    def getIpSetId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ipSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
    def getUpdates
        : ZIO[Any, Nothing, List[zio.aws.waf.model.IPSetUpdate.ReadOnly]] =
      ZIO.succeed(updates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateIpSetRequest
  ) extends zio.aws.waf.model.UpdateIpSetRequest.ReadOnly {
    override val ipSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ipSetId())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
    override val updates: List[zio.aws.waf.model.IPSetUpdate.ReadOnly] = impl
      .updates()
      .asScala
      .map { item =>
        zio.aws.waf.model.IPSetUpdate.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateIpSetRequest
  ): zio.aws.waf.model.UpdateIpSetRequest.ReadOnly = new Wrapper(impl)
}
