package zio.aws.waf.model
import scala.jdk.CollectionConverters.*
sealed trait WafActionType {
  def unwrap: software.amazon.awssdk.services.waf.model.WafActionType
}
object WafActionType {
  def wrap(
      value: software.amazon.awssdk.services.waf.model.WafActionType
  ): zio.aws.waf.model.WafActionType = value match {
    case software.amazon.awssdk.services.waf.model.WafActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.waf.model.WafActionType.BLOCK =>
      val r = BLOCK
      r
    case software.amazon.awssdk.services.waf.model.WafActionType.ALLOW =>
      val r = ALLOW
      r
    case software.amazon.awssdk.services.waf.model.WafActionType.COUNT =>
      val r = COUNT
      r
  }
  case object unknownToSdkVersion extends zio.aws.waf.model.WafActionType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.WafActionType =
      software.amazon.awssdk.services.waf.model.WafActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object BLOCK extends zio.aws.waf.model.WafActionType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.WafActionType =
      software.amazon.awssdk.services.waf.model.WafActionType.BLOCK
  }
  case object ALLOW extends zio.aws.waf.model.WafActionType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.WafActionType =
      software.amazon.awssdk.services.waf.model.WafActionType.ALLOW
  }
  case object COUNT extends zio.aws.waf.model.WafActionType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.WafActionType =
      software.amazon.awssdk.services.waf.model.WafActionType.COUNT
  }
}
