package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class XssMatchSetUpdate(
    action: zio.aws.waf.model.ChangeAction,
    xssMatchTuple: zio.aws.waf.model.XssMatchTuple
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.XssMatchSetUpdate = {
    import XssMatchSetUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.XssMatchSetUpdate
      .builder()
      .action(action.unwrap)
      .xssMatchTuple(xssMatchTuple.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.waf.model.XssMatchSetUpdate.ReadOnly =
    zio.aws.waf.model.XssMatchSetUpdate.wrap(buildAwsValue())
}
object XssMatchSetUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.XssMatchSetUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.XssMatchSetUpdate =
      zio.aws.waf.model.XssMatchSetUpdate(action, xssMatchTuple.asEditable)
    def action: zio.aws.waf.model.ChangeAction
    def xssMatchTuple: zio.aws.waf.model.XssMatchTuple.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.waf.model.ChangeAction] =
      ZIO.succeed(action)
    def getXssMatchTuple
        : ZIO[Any, Nothing, zio.aws.waf.model.XssMatchTuple.ReadOnly] =
      ZIO.succeed(xssMatchTuple)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.XssMatchSetUpdate
  ) extends zio.aws.waf.model.XssMatchSetUpdate.ReadOnly {
    override val action: zio.aws.waf.model.ChangeAction =
      zio.aws.waf.model.ChangeAction.wrap(impl.action())
    override val xssMatchTuple: zio.aws.waf.model.XssMatchTuple.ReadOnly =
      zio.aws.waf.model.XssMatchTuple.wrap(impl.xssMatchTuple())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.XssMatchSetUpdate
  ): zio.aws.waf.model.XssMatchSetUpdate.ReadOnly = new Wrapper(impl)
}
