package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters.*
final case class CreateSqlInjectionMatchSetResponse(
    sqlInjectionMatchSet: Optional[zio.aws.waf.model.SqlInjectionMatchSet] =
      Optional.Absent,
    changeToken: Optional[ChangeToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateSqlInjectionMatchSetResponse = {
    import CreateSqlInjectionMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateSqlInjectionMatchSetResponse
      .builder()
      .optionallyWith(sqlInjectionMatchSet.map(value => value.buildAwsValue()))(
        _.sqlInjectionMatchSet
      )
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly
      : zio.aws.waf.model.CreateSqlInjectionMatchSetResponse.ReadOnly =
    zio.aws.waf.model.CreateSqlInjectionMatchSetResponse.wrap(buildAwsValue())
}
object CreateSqlInjectionMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateSqlInjectionMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateSqlInjectionMatchSetResponse =
      zio.aws.waf.model.CreateSqlInjectionMatchSetResponse(
        sqlInjectionMatchSet.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def sqlInjectionMatchSet
        : Optional[zio.aws.waf.model.SqlInjectionMatchSet.ReadOnly]
    def changeToken: Optional[ChangeToken]
    def getSqlInjectionMatchSet
        : ZIO[Any, AwsError, zio.aws.waf.model.SqlInjectionMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("sqlInjectionMatchSet", sqlInjectionMatchSet)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateSqlInjectionMatchSetResponse
  ) extends zio.aws.waf.model.CreateSqlInjectionMatchSetResponse.ReadOnly {
    override val sqlInjectionMatchSet
        : Optional[zio.aws.waf.model.SqlInjectionMatchSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sqlInjectionMatchSet())
        .map(value => zio.aws.waf.model.SqlInjectionMatchSet.wrap(value))
    override val changeToken: Optional[ChangeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateSqlInjectionMatchSetResponse
  ): zio.aws.waf.model.CreateSqlInjectionMatchSetResponse.ReadOnly =
    new Wrapper(impl)
}
