package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters.*
final case class CreateWebAclResponse(
    webACL: Optional[zio.aws.waf.model.WebACL] = Optional.Absent,
    changeToken: Optional[ChangeToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateWebAclResponse = {
    import CreateWebAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateWebAclResponse
      .builder()
      .optionallyWith(webACL.map(value => value.buildAwsValue()))(_.webACL)
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateWebAclResponse.ReadOnly =
    zio.aws.waf.model.CreateWebAclResponse.wrap(buildAwsValue())
}
object CreateWebAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateWebAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateWebAclResponse =
      zio.aws.waf.model.CreateWebAclResponse(
        webACL.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def webACL: Optional[zio.aws.waf.model.WebACL.ReadOnly]
    def changeToken: Optional[ChangeToken]
    def getWebACL: ZIO[Any, AwsError, zio.aws.waf.model.WebACL.ReadOnly] =
      AwsError.unwrapOptionField("webACL", webACL)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateWebAclResponse
  ) extends zio.aws.waf.model.CreateWebAclResponse.ReadOnly {
    override val webACL: Optional[zio.aws.waf.model.WebACL.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.webACL())
        .map(value => zio.aws.waf.model.WebACL.wrap(value))
    override val changeToken: Optional[ChangeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateWebAclResponse
  ): zio.aws.waf.model.CreateWebAclResponse.ReadOnly = new Wrapper(impl)
}
