package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class ExcludedRule(ruleId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ExcludedRule = {
    import ExcludedRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ExcludedRule
      .builder()
      .ruleId(ResourceId.unwrap(ruleId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ExcludedRule.ReadOnly =
    zio.aws.waf.model.ExcludedRule.wrap(buildAwsValue())
}
object ExcludedRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.ExcludedRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ExcludedRule =
      zio.aws.waf.model.ExcludedRule(ruleId)
    def ruleId: ResourceId
    def getRuleId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ExcludedRule
  ) extends zio.aws.waf.model.ExcludedRule.ReadOnly {
    override val ruleId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ruleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ExcludedRule
  ): zio.aws.waf.model.ExcludedRule.ReadOnly = new Wrapper(impl)
}
