package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSizeConstraintSetResponse(
    sizeConstraintSet: Optional[zio.aws.waf.model.SizeConstraintSet] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetSizeConstraintSetResponse = {
    import GetSizeConstraintSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetSizeConstraintSetResponse
      .builder()
      .optionallyWith(sizeConstraintSet.map(value => value.buildAwsValue()))(
        _.sizeConstraintSet
      )
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetSizeConstraintSetResponse.ReadOnly =
    zio.aws.waf.model.GetSizeConstraintSetResponse.wrap(buildAwsValue())
}
object GetSizeConstraintSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetSizeConstraintSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetSizeConstraintSetResponse =
      zio.aws.waf.model.GetSizeConstraintSetResponse(
        sizeConstraintSet.map(value => value.asEditable)
      )
    def sizeConstraintSet
        : Optional[zio.aws.waf.model.SizeConstraintSet.ReadOnly]
    def getSizeConstraintSet
        : ZIO[Any, AwsError, zio.aws.waf.model.SizeConstraintSet.ReadOnly] =
      AwsError.unwrapOptionField("sizeConstraintSet", sizeConstraintSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetSizeConstraintSetResponse
  ) extends zio.aws.waf.model.GetSizeConstraintSetResponse.ReadOnly {
    override val sizeConstraintSet
        : Optional[zio.aws.waf.model.SizeConstraintSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sizeConstraintSet())
        .map(value => zio.aws.waf.model.SizeConstraintSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetSizeConstraintSetResponse
  ): zio.aws.waf.model.GetSizeConstraintSetResponse.ReadOnly = new Wrapper(impl)
}
