package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class GetWebAclRequest(webACLId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetWebAclRequest = {
    import GetWebAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetWebAclRequest
      .builder()
      .webACLId(ResourceId.unwrap(webACLId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetWebAclRequest.ReadOnly =
    zio.aws.waf.model.GetWebAclRequest.wrap(buildAwsValue())
}
object GetWebAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetWebAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetWebAclRequest =
      zio.aws.waf.model.GetWebAclRequest(webACLId)
    def webACLId: ResourceId
    def getWebACLId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(webACLId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetWebAclRequest
  ) extends zio.aws.waf.model.GetWebAclRequest.ReadOnly {
    override val webACLId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.webACLId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetWebAclRequest
  ): zio.aws.waf.model.GetWebAclRequest.ReadOnly = new Wrapper(impl)
}
