package zio.aws.waf.model
import zio.aws.waf.model.primitives.{PaginationLimit, NextMarker}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSqlInjectionMatchSetsRequest(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    limit: Optional[PaginationLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsRequest = {
    import ListSqlInjectionMatchSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsRequest
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        limit.map(value => PaginationLimit.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ListSqlInjectionMatchSetsRequest.ReadOnly =
    zio.aws.waf.model.ListSqlInjectionMatchSetsRequest.wrap(buildAwsValue())
}
object ListSqlInjectionMatchSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ListSqlInjectionMatchSetsRequest =
      zio.aws.waf.model.ListSqlInjectionMatchSetsRequest(
        nextMarker.map(value => value),
        limit.map(value => value)
      )
    def nextMarker: Optional[NextMarker]
    def limit: Optional[PaginationLimit]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getLimit: ZIO[Any, AwsError, PaginationLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsRequest
  ) extends zio.aws.waf.model.ListSqlInjectionMatchSetsRequest.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
    override val limit: Optional[PaginationLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.waf.model.primitives.PaginationLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsRequest
  ): zio.aws.waf.model.ListSqlInjectionMatchSetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
