package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.NextMarker
import scala.jdk.CollectionConverters.*
final case class ListSqlInjectionMatchSetsResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    sqlInjectionMatchSets: Optional[
      Iterable[zio.aws.waf.model.SqlInjectionMatchSetSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsResponse = {
    import ListSqlInjectionMatchSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        sqlInjectionMatchSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sqlInjectionMatchSets)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ListSqlInjectionMatchSetsResponse.ReadOnly =
    zio.aws.waf.model.ListSqlInjectionMatchSetsResponse.wrap(buildAwsValue())
}
object ListSqlInjectionMatchSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ListSqlInjectionMatchSetsResponse =
      zio.aws.waf.model.ListSqlInjectionMatchSetsResponse(
        nextMarker.map(value => value),
        sqlInjectionMatchSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[NextMarker]
    def sqlInjectionMatchSets
        : Optional[List[zio.aws.waf.model.SqlInjectionMatchSetSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getSqlInjectionMatchSets: ZIO[Any, AwsError, List[
      zio.aws.waf.model.SqlInjectionMatchSetSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("sqlInjectionMatchSets", sqlInjectionMatchSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsResponse
  ) extends zio.aws.waf.model.ListSqlInjectionMatchSetsResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
    override val sqlInjectionMatchSets: Optional[
      List[zio.aws.waf.model.SqlInjectionMatchSetSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sqlInjectionMatchSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.waf.model.SqlInjectionMatchSetSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsResponse
  ): zio.aws.waf.model.ListSqlInjectionMatchSetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
