package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RegexMatchSetUpdate(
    action: zio.aws.waf.model.ChangeAction,
    regexMatchTuple: zio.aws.waf.model.RegexMatchTuple
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.RegexMatchSetUpdate = {
    import RegexMatchSetUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RegexMatchSetUpdate
      .builder()
      .action(action.unwrap)
      .regexMatchTuple(regexMatchTuple.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.waf.model.RegexMatchSetUpdate.ReadOnly =
    zio.aws.waf.model.RegexMatchSetUpdate.wrap(buildAwsValue())
}
object RegexMatchSetUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.RegexMatchSetUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.RegexMatchSetUpdate =
      zio.aws.waf.model.RegexMatchSetUpdate(action, regexMatchTuple.asEditable)
    def action: zio.aws.waf.model.ChangeAction
    def regexMatchTuple: zio.aws.waf.model.RegexMatchTuple.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.waf.model.ChangeAction] =
      ZIO.succeed(action)
    def getRegexMatchTuple
        : ZIO[Any, Nothing, zio.aws.waf.model.RegexMatchTuple.ReadOnly] =
      ZIO.succeed(regexMatchTuple)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RegexMatchSetUpdate
  ) extends zio.aws.waf.model.RegexMatchSetUpdate.ReadOnly {
    override val action: zio.aws.waf.model.ChangeAction =
      zio.aws.waf.model.ChangeAction.wrap(impl.action())
    override val regexMatchTuple: zio.aws.waf.model.RegexMatchTuple.ReadOnly =
      zio.aws.waf.model.RegexMatchTuple.wrap(impl.regexMatchTuple())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RegexMatchSetUpdate
  ): zio.aws.waf.model.RegexMatchSetUpdate.ReadOnly = new Wrapper(impl)
}
