package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ResourceName, ResourceId}
import scala.jdk.CollectionConverters.*
final case class SizeConstraintSetSummary(
    sizeConstraintSetId: ResourceId,
    name: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.SizeConstraintSetSummary = {
    import SizeConstraintSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.SizeConstraintSetSummary
      .builder()
      .sizeConstraintSetId(
        ResourceId.unwrap(sizeConstraintSetId): java.lang.String
      )
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.SizeConstraintSetSummary.ReadOnly =
    zio.aws.waf.model.SizeConstraintSetSummary.wrap(buildAwsValue())
}
object SizeConstraintSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.SizeConstraintSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.SizeConstraintSetSummary =
      zio.aws.waf.model.SizeConstraintSetSummary(sizeConstraintSetId, name)
    def sizeConstraintSetId: ResourceId
    def name: ResourceName
    def getSizeConstraintSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(sizeConstraintSetId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.SizeConstraintSetSummary
  ) extends zio.aws.waf.model.SizeConstraintSetSummary.ReadOnly {
    override val sizeConstraintSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.sizeConstraintSetId())
    override val name: ResourceName =
      zio.aws.waf.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.SizeConstraintSetSummary
  ): zio.aws.waf.model.SizeConstraintSetSummary.ReadOnly = new Wrapper(impl)
}
