package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ResourceName, ResourceId}
import scala.jdk.CollectionConverters.*
final case class SqlInjectionMatchSetSummary(
    sqlInjectionMatchSetId: ResourceId,
    name: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummary = {
    import SqlInjectionMatchSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummary
      .builder()
      .sqlInjectionMatchSetId(
        ResourceId.unwrap(sqlInjectionMatchSetId): java.lang.String
      )
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.SqlInjectionMatchSetSummary.ReadOnly =
    zio.aws.waf.model.SqlInjectionMatchSetSummary.wrap(buildAwsValue())
}
object SqlInjectionMatchSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.SqlInjectionMatchSetSummary =
      zio.aws.waf.model
        .SqlInjectionMatchSetSummary(sqlInjectionMatchSetId, name)
    def sqlInjectionMatchSetId: ResourceId
    def name: ResourceName
    def getSqlInjectionMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(sqlInjectionMatchSetId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummary
  ) extends zio.aws.waf.model.SqlInjectionMatchSetSummary.ReadOnly {
    override val sqlInjectionMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.sqlInjectionMatchSetId())
    override val name: ResourceName =
      zio.aws.waf.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummary
  ): zio.aws.waf.model.SqlInjectionMatchSetSummary.ReadOnly = new Wrapper(impl)
}
