package zio.aws.waf.model
import scala.jdk.CollectionConverters.*
sealed trait TextTransformation {
  def unwrap: software.amazon.awssdk.services.waf.model.TextTransformation
}
object TextTransformation {
  def wrap(
      value: software.amazon.awssdk.services.waf.model.TextTransformation
  ): zio.aws.waf.model.TextTransformation = value match {
    case software.amazon.awssdk.services.waf.model.TextTransformation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.waf.model.TextTransformation.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.waf.model.TextTransformation.COMPRESS_WHITE_SPACE =>
      val r = COMPRESS_WHITE_SPACE
      r
    case software.amazon.awssdk.services.waf.model.TextTransformation.HTML_ENTITY_DECODE =>
      val r = HTML_ENTITY_DECODE
      r
    case software.amazon.awssdk.services.waf.model.TextTransformation.LOWERCASE =>
      val r = LOWERCASE
      r
    case software.amazon.awssdk.services.waf.model.TextTransformation.CMD_LINE =>
      val r = CMD_LINE
      r
    case software.amazon.awssdk.services.waf.model.TextTransformation.URL_DECODE =>
      val r = URL_DECODE
      r
  }
  case object unknownToSdkVersion extends zio.aws.waf.model.TextTransformation {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.TextTransformation =
      software.amazon.awssdk.services.waf.model.TextTransformation.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.waf.model.TextTransformation {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.TextTransformation =
      software.amazon.awssdk.services.waf.model.TextTransformation.NONE
  }
  case object COMPRESS_WHITE_SPACE
      extends zio.aws.waf.model.TextTransformation {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.TextTransformation =
      software.amazon.awssdk.services.waf.model.TextTransformation.COMPRESS_WHITE_SPACE
  }
  case object HTML_ENTITY_DECODE extends zio.aws.waf.model.TextTransformation {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.TextTransformation =
      software.amazon.awssdk.services.waf.model.TextTransformation.HTML_ENTITY_DECODE
  }
  case object LOWERCASE extends zio.aws.waf.model.TextTransformation {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.TextTransformation =
      software.amazon.awssdk.services.waf.model.TextTransformation.LOWERCASE
  }
  case object CMD_LINE extends zio.aws.waf.model.TextTransformation {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.TextTransformation =
      software.amazon.awssdk.services.waf.model.TextTransformation.CMD_LINE
  }
  case object URL_DECODE extends zio.aws.waf.model.TextTransformation {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.TextTransformation =
      software.amazon.awssdk.services.waf.model.TextTransformation.URL_DECODE
  }
}
