package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters.*
final case class UpdateXssMatchSetRequest(
    xssMatchSetId: ResourceId,
    changeToken: ChangeToken,
    updates: Iterable[zio.aws.waf.model.XssMatchSetUpdate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateXssMatchSetRequest = {
    import UpdateXssMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateXssMatchSetRequest
      .builder()
      .xssMatchSetId(ResourceId.unwrap(xssMatchSetId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .updates(updates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.UpdateXssMatchSetRequest.ReadOnly =
    zio.aws.waf.model.UpdateXssMatchSetRequest.wrap(buildAwsValue())
}
object UpdateXssMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateXssMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.UpdateXssMatchSetRequest =
      zio.aws.waf.model.UpdateXssMatchSetRequest(
        xssMatchSetId,
        changeToken,
        updates.map { item =>
          item.asEditable
        }
      )
    def xssMatchSetId: ResourceId
    def changeToken: ChangeToken
    def updates: List[zio.aws.waf.model.XssMatchSetUpdate.ReadOnly]
    def getXssMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(xssMatchSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
    def getUpdates: ZIO[Any, Nothing, List[
      zio.aws.waf.model.XssMatchSetUpdate.ReadOnly
    ]] = ZIO.succeed(updates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateXssMatchSetRequest
  ) extends zio.aws.waf.model.UpdateXssMatchSetRequest.ReadOnly {
    override val xssMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.xssMatchSetId())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
    override val updates: List[zio.aws.waf.model.XssMatchSetUpdate.ReadOnly] =
      impl
        .updates()
        .asScala
        .map { item =>
          zio.aws.waf.model.XssMatchSetUpdate.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateXssMatchSetRequest
  ): zio.aws.waf.model.UpdateXssMatchSetRequest.ReadOnly = new Wrapper(impl)
}
