package zio.aws.waf.model
import scala.jdk.CollectionConverters.*
sealed trait WafRuleType {
  def unwrap: software.amazon.awssdk.services.waf.model.WafRuleType
}
object WafRuleType {
  def wrap(
      value: software.amazon.awssdk.services.waf.model.WafRuleType
  ): zio.aws.waf.model.WafRuleType = value match {
    case software.amazon.awssdk.services.waf.model.WafRuleType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.waf.model.WafRuleType.REGULAR =>
      val r = REGULAR
      r
    case software.amazon.awssdk.services.waf.model.WafRuleType.RATE_BASED =>
      val r = RATE_BASED
      r
    case software.amazon.awssdk.services.waf.model.WafRuleType.GROUP =>
      val r = GROUP
      r
  }
  case object unknownToSdkVersion extends zio.aws.waf.model.WafRuleType {
    override def unwrap: software.amazon.awssdk.services.waf.model.WafRuleType =
      software.amazon.awssdk.services.waf.model.WafRuleType.UNKNOWN_TO_SDK_VERSION
  }
  case object REGULAR extends zio.aws.waf.model.WafRuleType {
    override def unwrap: software.amazon.awssdk.services.waf.model.WafRuleType =
      software.amazon.awssdk.services.waf.model.WafRuleType.REGULAR
  }
  case object RATE_BASED extends zio.aws.waf.model.WafRuleType {
    override def unwrap: software.amazon.awssdk.services.waf.model.WafRuleType =
      software.amazon.awssdk.services.waf.model.WafRuleType.RATE_BASED
  }
  case object GROUP extends zio.aws.waf.model.WafRuleType {
    override def unwrap: software.amazon.awssdk.services.waf.model.WafRuleType =
      software.amazon.awssdk.services.waf.model.WafRuleType.GROUP
  }
}
