package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.{ResourceName, ResourceId}
import scala.jdk.CollectionConverters.*
final case class XssMatchSet(
    xssMatchSetId: ResourceId,
    name: Optional[ResourceName] = Optional.Absent,
    xssMatchTuples: Iterable[zio.aws.waf.model.XssMatchTuple]
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.XssMatchSet = {
    import XssMatchSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.XssMatchSet
      .builder()
      .xssMatchSetId(ResourceId.unwrap(xssMatchSetId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .xssMatchTuples(xssMatchTuples.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.XssMatchSet.ReadOnly =
    zio.aws.waf.model.XssMatchSet.wrap(buildAwsValue())
}
object XssMatchSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.XssMatchSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.XssMatchSet =
      zio.aws.waf.model.XssMatchSet(
        xssMatchSetId,
        name.map(value => value),
        xssMatchTuples.map { item =>
          item.asEditable
        }
      )
    def xssMatchSetId: ResourceId
    def name: Optional[ResourceName]
    def xssMatchTuples: List[zio.aws.waf.model.XssMatchTuple.ReadOnly]
    def getXssMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(xssMatchSetId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getXssMatchTuples
        : ZIO[Any, Nothing, List[zio.aws.waf.model.XssMatchTuple.ReadOnly]] =
      ZIO.succeed(xssMatchTuples)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.XssMatchSet
  ) extends zio.aws.waf.model.XssMatchSet.ReadOnly {
    override val xssMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.xssMatchSetId())
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.waf.model.primitives.ResourceName(value))
    override val xssMatchTuples
        : List[zio.aws.waf.model.XssMatchTuple.ReadOnly] = impl
      .xssMatchTuples()
      .asScala
      .map { item =>
        zio.aws.waf.model.XssMatchTuple.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.XssMatchSet
  ): zio.aws.waf.model.XssMatchSet.ReadOnly = new Wrapper(impl)
}
