package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class XssMatchTuple(
    fieldToMatch: zio.aws.waf.model.FieldToMatch,
    textTransformation: zio.aws.waf.model.TextTransformation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.XssMatchTuple = {
    import XssMatchTuple.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.XssMatchTuple
      .builder()
      .fieldToMatch(fieldToMatch.buildAwsValue())
      .textTransformation(textTransformation.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.XssMatchTuple.ReadOnly =
    zio.aws.waf.model.XssMatchTuple.wrap(buildAwsValue())
}
object XssMatchTuple {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.XssMatchTuple] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.XssMatchTuple = zio.aws.waf.model
      .XssMatchTuple(fieldToMatch.asEditable, textTransformation)
    def fieldToMatch: zio.aws.waf.model.FieldToMatch.ReadOnly
    def textTransformation: zio.aws.waf.model.TextTransformation
    def getFieldToMatch
        : ZIO[Any, Nothing, zio.aws.waf.model.FieldToMatch.ReadOnly] =
      ZIO.succeed(fieldToMatch)
    def getTextTransformation
        : ZIO[Any, Nothing, zio.aws.waf.model.TextTransformation] =
      ZIO.succeed(textTransformation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.XssMatchTuple
  ) extends zio.aws.waf.model.XssMatchTuple.ReadOnly {
    override val fieldToMatch: zio.aws.waf.model.FieldToMatch.ReadOnly =
      zio.aws.waf.model.FieldToMatch.wrap(impl.fieldToMatch())
    override val textTransformation: zio.aws.waf.model.TextTransformation =
      zio.aws.waf.model.TextTransformation.wrap(impl.textTransformation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.XssMatchTuple
  ): zio.aws.waf.model.XssMatchTuple.ReadOnly = new Wrapper(impl)
}
