package zio.aws.waf.model
import zio.aws.waf.model.primitives.{ResourceId, RulePriority}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ActivatedRule(
    priority: RulePriority,
    ruleId: ResourceId,
    action: Optional[zio.aws.waf.model.WafAction] = Optional.Absent,
    overrideAction: Optional[zio.aws.waf.model.WafOverrideAction] =
      Optional.Absent,
    `type`: Optional[zio.aws.waf.model.WafRuleType] = Optional.Absent,
    excludedRules: Optional[Iterable[zio.aws.waf.model.ExcludedRule]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ActivatedRule = {
    import ActivatedRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ActivatedRule
      .builder()
      .priority(RulePriority.unwrap(priority): Integer)
      .ruleId(ResourceId.unwrap(ruleId): java.lang.String)
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(overrideAction.map(value => value.buildAwsValue()))(
        _.overrideAction
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        excludedRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludedRules)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ActivatedRule.ReadOnly =
    zio.aws.waf.model.ActivatedRule.wrap(buildAwsValue())
}
object ActivatedRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.ActivatedRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ActivatedRule =
      zio.aws.waf.model.ActivatedRule(
        priority,
        ruleId,
        action.map(value => value.asEditable),
        overrideAction.map(value => value.asEditable),
        `type`.map(value => value),
        excludedRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def priority: RulePriority
    def ruleId: ResourceId
    def action: Optional[zio.aws.waf.model.WafAction.ReadOnly]
    def overrideAction: Optional[zio.aws.waf.model.WafOverrideAction.ReadOnly]
    def `type`: Optional[zio.aws.waf.model.WafRuleType]
    def excludedRules: Optional[List[zio.aws.waf.model.ExcludedRule.ReadOnly]]
    def getPriority: ZIO[Any, Nothing, RulePriority] = ZIO.succeed(priority)
    def getRuleId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleId)
    def getAction: ZIO[Any, AwsError, zio.aws.waf.model.WafAction.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
    def getOverrideAction
        : ZIO[Any, AwsError, zio.aws.waf.model.WafOverrideAction.ReadOnly] =
      AwsError.unwrapOptionField("overrideAction", overrideAction)
    def getType: ZIO[Any, AwsError, zio.aws.waf.model.WafRuleType] =
      AwsError.unwrapOptionField("type", `type`)
    def getExcludedRules
        : ZIO[Any, AwsError, List[zio.aws.waf.model.ExcludedRule.ReadOnly]] =
      AwsError.unwrapOptionField("excludedRules", excludedRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ActivatedRule
  ) extends zio.aws.waf.model.ActivatedRule.ReadOnly {
    override val priority: RulePriority =
      zio.aws.waf.model.primitives.RulePriority(impl.priority())
    override val ruleId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ruleId())
    override val action: Optional[zio.aws.waf.model.WafAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.waf.model.WafAction.wrap(value))
    override val overrideAction
        : Optional[zio.aws.waf.model.WafOverrideAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrideAction())
        .map(value => zio.aws.waf.model.WafOverrideAction.wrap(value))
    override val `type`: Optional[zio.aws.waf.model.WafRuleType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.waf.model.WafRuleType.wrap(value))
    override val excludedRules
        : Optional[List[zio.aws.waf.model.ExcludedRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludedRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.waf.model.ExcludedRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ActivatedRule
  ): zio.aws.waf.model.ActivatedRule.ReadOnly = new Wrapper(impl)
}
