package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ByteMatchTargetString
import scala.jdk.CollectionConverters.*
final case class ByteMatchTuple(
    fieldToMatch: zio.aws.waf.model.FieldToMatch,
    targetString: ByteMatchTargetString,
    textTransformation: zio.aws.waf.model.TextTransformation,
    positionalConstraint: zio.aws.waf.model.PositionalConstraint
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ByteMatchTuple = {
    import ByteMatchTuple.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ByteMatchTuple
      .builder()
      .fieldToMatch(fieldToMatch.buildAwsValue())
      .targetString(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(targetString.toArray[Byte])
      )
      .textTransformation(textTransformation.unwrap)
      .positionalConstraint(positionalConstraint.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ByteMatchTuple.ReadOnly =
    zio.aws.waf.model.ByteMatchTuple.wrap(buildAwsValue())
}
object ByteMatchTuple {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ByteMatchTuple
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ByteMatchTuple =
      zio.aws.waf.model.ByteMatchTuple(
        fieldToMatch.asEditable,
        targetString,
        textTransformation,
        positionalConstraint
      )
    def fieldToMatch: zio.aws.waf.model.FieldToMatch.ReadOnly
    def targetString: ByteMatchTargetString
    def textTransformation: zio.aws.waf.model.TextTransformation
    def positionalConstraint: zio.aws.waf.model.PositionalConstraint
    def getFieldToMatch
        : ZIO[Any, Nothing, zio.aws.waf.model.FieldToMatch.ReadOnly] =
      ZIO.succeed(fieldToMatch)
    def getTargetString: ZIO[Any, Nothing, ByteMatchTargetString] =
      ZIO.succeed(targetString)
    def getTextTransformation
        : ZIO[Any, Nothing, zio.aws.waf.model.TextTransformation] =
      ZIO.succeed(textTransformation)
    def getPositionalConstraint
        : ZIO[Any, Nothing, zio.aws.waf.model.PositionalConstraint] =
      ZIO.succeed(positionalConstraint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ByteMatchTuple
  ) extends zio.aws.waf.model.ByteMatchTuple.ReadOnly {
    override val fieldToMatch: zio.aws.waf.model.FieldToMatch.ReadOnly =
      zio.aws.waf.model.FieldToMatch.wrap(impl.fieldToMatch())
    override val targetString: ByteMatchTargetString =
      zio.aws.waf.model.primitives.ByteMatchTargetString(
        zio.Chunk.fromArray(impl.targetString().asByteArrayUnsafe())
      )
    override val textTransformation: zio.aws.waf.model.TextTransformation =
      zio.aws.waf.model.TextTransformation.wrap(impl.textTransformation())
    override val positionalConstraint: zio.aws.waf.model.PositionalConstraint =
      zio.aws.waf.model.PositionalConstraint.wrap(impl.positionalConstraint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ByteMatchTuple
  ): zio.aws.waf.model.ByteMatchTuple.ReadOnly = new Wrapper(impl)
}
