package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceName}
import scala.jdk.CollectionConverters.*
final case class CreateGeoMatchSetRequest(
    name: ResourceName,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateGeoMatchSetRequest = {
    import CreateGeoMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateGeoMatchSetRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateGeoMatchSetRequest.ReadOnly =
    zio.aws.waf.model.CreateGeoMatchSetRequest.wrap(buildAwsValue())
}
object CreateGeoMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateGeoMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateGeoMatchSetRequest =
      zio.aws.waf.model.CreateGeoMatchSetRequest(name, changeToken)
    def name: ResourceName
    def changeToken: ChangeToken
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateGeoMatchSetRequest
  ) extends zio.aws.waf.model.CreateGeoMatchSetRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.waf.model.primitives.ResourceName(impl.name())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateGeoMatchSetRequest
  ): zio.aws.waf.model.CreateGeoMatchSetRequest.ReadOnly = new Wrapper(impl)
}
