package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters.*
final case class DeleteRuleGroupResponse(
    changeToken: Optional[ChangeToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteRuleGroupResponse = {
    import DeleteRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteRuleGroupResponse
      .builder()
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.DeleteRuleGroupResponse.ReadOnly =
    zio.aws.waf.model.DeleteRuleGroupResponse.wrap(buildAwsValue())
}
object DeleteRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.DeleteRuleGroupResponse =
      zio.aws.waf.model.DeleteRuleGroupResponse(changeToken.map(value => value))
    def changeToken: Optional[ChangeToken]
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteRuleGroupResponse
  ) extends zio.aws.waf.model.DeleteRuleGroupResponse.ReadOnly {
    override val changeToken: Optional[ChangeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteRuleGroupResponse
  ): zio.aws.waf.model.DeleteRuleGroupResponse.ReadOnly = new Wrapper(impl)
}
