package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters.*
final case class DeleteSizeConstraintSetRequest(
    sizeConstraintSetId: ResourceId,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetRequest = {
    import DeleteSizeConstraintSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetRequest
      .builder()
      .sizeConstraintSetId(
        ResourceId.unwrap(sizeConstraintSetId): java.lang.String
      )
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.DeleteSizeConstraintSetRequest.ReadOnly =
    zio.aws.waf.model.DeleteSizeConstraintSetRequest.wrap(buildAwsValue())
}
object DeleteSizeConstraintSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.DeleteSizeConstraintSetRequest =
      zio.aws.waf.model
        .DeleteSizeConstraintSetRequest(sizeConstraintSetId, changeToken)
    def sizeConstraintSetId: ResourceId
    def changeToken: ChangeToken
    def getSizeConstraintSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(sizeConstraintSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetRequest
  ) extends zio.aws.waf.model.DeleteSizeConstraintSetRequest.ReadOnly {
    override val sizeConstraintSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.sizeConstraintSetId())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetRequest
  ): zio.aws.waf.model.DeleteSizeConstraintSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
