package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters.*
final case class DeleteSqlInjectionMatchSetRequest(
    sqlInjectionMatchSetId: ResourceId,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteSqlInjectionMatchSetRequest = {
    import DeleteSqlInjectionMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteSqlInjectionMatchSetRequest
      .builder()
      .sqlInjectionMatchSetId(
        ResourceId.unwrap(sqlInjectionMatchSetId): java.lang.String
      )
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.DeleteSqlInjectionMatchSetRequest.ReadOnly =
    zio.aws.waf.model.DeleteSqlInjectionMatchSetRequest.wrap(buildAwsValue())
}
object DeleteSqlInjectionMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteSqlInjectionMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.DeleteSqlInjectionMatchSetRequest =
      zio.aws.waf.model
        .DeleteSqlInjectionMatchSetRequest(sqlInjectionMatchSetId, changeToken)
    def sqlInjectionMatchSetId: ResourceId
    def changeToken: ChangeToken
    def getSqlInjectionMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(sqlInjectionMatchSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteSqlInjectionMatchSetRequest
  ) extends zio.aws.waf.model.DeleteSqlInjectionMatchSetRequest.ReadOnly {
    override val sqlInjectionMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.sqlInjectionMatchSetId())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteSqlInjectionMatchSetRequest
  ): zio.aws.waf.model.DeleteSqlInjectionMatchSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
