package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetChangeTokenStatusResponse(
    changeTokenStatus: Optional[zio.aws.waf.model.ChangeTokenStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetChangeTokenStatusResponse = {
    import GetChangeTokenStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetChangeTokenStatusResponse
      .builder()
      .optionallyWith(changeTokenStatus.map(value => value.unwrap))(
        _.changeTokenStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetChangeTokenStatusResponse.ReadOnly =
    zio.aws.waf.model.GetChangeTokenStatusResponse.wrap(buildAwsValue())
}
object GetChangeTokenStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetChangeTokenStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetChangeTokenStatusResponse =
      zio.aws.waf.model
        .GetChangeTokenStatusResponse(changeTokenStatus.map(value => value))
    def changeTokenStatus: Optional[zio.aws.waf.model.ChangeTokenStatus]
    def getChangeTokenStatus
        : ZIO[Any, AwsError, zio.aws.waf.model.ChangeTokenStatus] =
      AwsError.unwrapOptionField("changeTokenStatus", changeTokenStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetChangeTokenStatusResponse
  ) extends zio.aws.waf.model.GetChangeTokenStatusResponse.ReadOnly {
    override val changeTokenStatus
        : Optional[zio.aws.waf.model.ChangeTokenStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.changeTokenStatus())
      .map(value => zio.aws.waf.model.ChangeTokenStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetChangeTokenStatusResponse
  ): zio.aws.waf.model.GetChangeTokenStatusResponse.ReadOnly = new Wrapper(impl)
}
