package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class GetRateBasedRuleRequest(ruleId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRateBasedRuleRequest = {
    import GetRateBasedRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRateBasedRuleRequest
      .builder()
      .ruleId(ResourceId.unwrap(ruleId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetRateBasedRuleRequest.ReadOnly =
    zio.aws.waf.model.GetRateBasedRuleRequest.wrap(buildAwsValue())
}
object GetRateBasedRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRateBasedRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetRateBasedRuleRequest =
      zio.aws.waf.model.GetRateBasedRuleRequest(ruleId)
    def ruleId: ResourceId
    def getRuleId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRateBasedRuleRequest
  ) extends zio.aws.waf.model.GetRateBasedRuleRequest.ReadOnly {
    override val ruleId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ruleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRateBasedRuleRequest
  ): zio.aws.waf.model.GetRateBasedRuleRequest.ReadOnly = new Wrapper(impl)
}
