package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class GetRegexMatchSetRequest(regexMatchSetId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRegexMatchSetRequest = {
    import GetRegexMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRegexMatchSetRequest
      .builder()
      .regexMatchSetId(ResourceId.unwrap(regexMatchSetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetRegexMatchSetRequest.ReadOnly =
    zio.aws.waf.model.GetRegexMatchSetRequest.wrap(buildAwsValue())
}
object GetRegexMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRegexMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetRegexMatchSetRequest =
      zio.aws.waf.model.GetRegexMatchSetRequest(regexMatchSetId)
    def regexMatchSetId: ResourceId
    def getRegexMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(regexMatchSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRegexMatchSetRequest
  ) extends zio.aws.waf.model.GetRegexMatchSetRequest.ReadOnly {
    override val regexMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.regexMatchSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRegexMatchSetRequest
  ): zio.aws.waf.model.GetRegexMatchSetRequest.ReadOnly = new Wrapper(impl)
}
