package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRuleResponse(
    rule: Optional[zio.aws.waf.model.Rule] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRuleResponse = {
    import GetRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRuleResponse
      .builder()
      .optionallyWith(rule.map(value => value.buildAwsValue()))(_.rule)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetRuleResponse.ReadOnly =
    zio.aws.waf.model.GetRuleResponse.wrap(buildAwsValue())
}
object GetRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetRuleResponse =
      zio.aws.waf.model.GetRuleResponse(rule.map(value => value.asEditable))
    def rule: Optional[zio.aws.waf.model.Rule.ReadOnly]
    def getRule: ZIO[Any, AwsError, zio.aws.waf.model.Rule.ReadOnly] =
      AwsError.unwrapOptionField("rule", rule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRuleResponse
  ) extends zio.aws.waf.model.GetRuleResponse.ReadOnly {
    override val rule: Optional[zio.aws.waf.model.Rule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rule())
        .map(value => zio.aws.waf.model.Rule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRuleResponse
  ): zio.aws.waf.model.GetRuleResponse.ReadOnly = new Wrapper(impl)
}
