package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class IPSetUpdate(
    action: zio.aws.waf.model.ChangeAction,
    ipSetDescriptor: zio.aws.waf.model.IPSetDescriptor
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.IPSetUpdate = {
    import IPSetUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.IPSetUpdate
      .builder()
      .action(action.unwrap)
      .ipSetDescriptor(ipSetDescriptor.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.waf.model.IPSetUpdate.ReadOnly =
    zio.aws.waf.model.IPSetUpdate.wrap(buildAwsValue())
}
object IPSetUpdate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.IPSetUpdate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.IPSetUpdate =
      zio.aws.waf.model.IPSetUpdate(action, ipSetDescriptor.asEditable)
    def action: zio.aws.waf.model.ChangeAction
    def ipSetDescriptor: zio.aws.waf.model.IPSetDescriptor.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.waf.model.ChangeAction] =
      ZIO.succeed(action)
    def getIpSetDescriptor
        : ZIO[Any, Nothing, zio.aws.waf.model.IPSetDescriptor.ReadOnly] =
      ZIO.succeed(ipSetDescriptor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.IPSetUpdate
  ) extends zio.aws.waf.model.IPSetUpdate.ReadOnly {
    override val action: zio.aws.waf.model.ChangeAction =
      zio.aws.waf.model.ChangeAction.wrap(impl.action())
    override val ipSetDescriptor: zio.aws.waf.model.IPSetDescriptor.ReadOnly =
      zio.aws.waf.model.IPSetDescriptor.wrap(impl.ipSetDescriptor())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.IPSetUpdate
  ): zio.aws.waf.model.IPSetUpdate.ReadOnly = new Wrapper(impl)
}
