package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.NextMarker
import scala.jdk.CollectionConverters.*
final case class ListByteMatchSetsResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    byteMatchSets: Optional[Iterable[zio.aws.waf.model.ByteMatchSetSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListByteMatchSetsResponse = {
    import ListByteMatchSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListByteMatchSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        byteMatchSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.byteMatchSets)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ListByteMatchSetsResponse.ReadOnly =
    zio.aws.waf.model.ListByteMatchSetsResponse.wrap(buildAwsValue())
}
object ListByteMatchSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListByteMatchSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ListByteMatchSetsResponse =
      zio.aws.waf.model.ListByteMatchSetsResponse(
        nextMarker.map(value => value),
        byteMatchSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[NextMarker]
    def byteMatchSets
        : Optional[List[zio.aws.waf.model.ByteMatchSetSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getByteMatchSets: ZIO[Any, AwsError, List[
      zio.aws.waf.model.ByteMatchSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("byteMatchSets", byteMatchSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListByteMatchSetsResponse
  ) extends zio.aws.waf.model.ListByteMatchSetsResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
    override val byteMatchSets
        : Optional[List[zio.aws.waf.model.ByteMatchSetSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.byteMatchSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.waf.model.ByteMatchSetSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListByteMatchSetsResponse
  ): zio.aws.waf.model.ListByteMatchSetsResponse.ReadOnly = new Wrapper(impl)
}
